/*
 * Modified by Vlad Danilov (designplugins.com)
 * 
 * ===============================================
 * =      Adobe Photoshop Add-ons Installer      =
 * =   (Because Adobe Extension Manager Sucks)   =
 * ===============================================
 * 
 *      Copyright: (c)2015, Davide Barranca
 * www.davidebarranca.com || www.cs-extensions.com
 * MIT License: http://opensource.org/licenses/MIT
 * 
 *   Thanks to xbytor for his xtools installer,
 *    which has been a source of inspiration!
 * 
 * ===============================================
 */
#target photoshop

/*
 * Globals
 * @type {Object}
 */
var G, PSInstaller, PSUtils, _PSUtils, psInstaller;

G = {

    /* INFO ======================================= */
    COMPANY: "Design Plugins",
    CONTACT_INFO: "vladmdanilov@gmail.com",
    PRODUCT_NAME: "Smart Slices Lite",
    PRODUCT_ID: "com.designplugins.smartslices.lite",
    PRODUCT_VERSION: "1.4.1",

    /* PRODUCTS =================================== */

    /* Photoshop versions range */

    /* Leave undefined for no limit */
    MIN_VERSION: 14,
    MAX_VERSION: void 0,

    /* Product Source Folders */

    /* Leave undefined for no product to install */

    /* Make sure tha paths (relative to the installer.jsx) do NOT start or end with "/" */
    HTML_PANEL: "bundle/html",
    FLASH_PANEL: "bundle/flash",
    SCRIPTS: "bundle/scripts",
    MAC_PLUGIN: "bundle/mac",
    WIN_PLUGIN: "bundle/win",
    EXTRA: void 0,

    /* If you have a readme file to display, put it here (path and filename) */
    README: "readme.txt",

    /* Depending on the PS version, what to install (not the classiest way but it works) */
    DEPENDENCIES: {
        "*": ["HTML_PANEL"]
    },

    /* System vs. User installation */
    SYSTEM_INSTALL: false,

    /* DEBUG ===================================== */
    INSTALLER_VERSION: "0.1.1",
    ENABLE_LOG: true,
    LOG_FILE_PATH: "~/Desktop",

    /* will be created as LOG_FILE_PATH / PRODUCT_NAME.log */
    LOG_FILE: "",

    /* Array of RegExp for Files to be ignored (escape "\" -> "\\") 
        Possibly a very bad idea, because the HTML Panel Signing and Timestamping
        may easily get corrupted if something is missing in the folder.
        Examples:
        IGNORE       : [  
            "^\\.\\w+", // starting with . 
            "^\\_\\w+", // starting with _ 
        ]
        Leaving undefined means: don't ignore
     */
    IGNORE: void 0,

    /* UTILS ===================================== */
    CURRENT_PATH: File($.fileName).path,
    CURRENT_PS_VERSION: app.version.split('.')[0]
};


/*
 * Utility functions
 * Mostly borrowed from xbytor's xtools installer 
 * http://sourceforge.net/projects/ps-scripts/files/xtools/
 * License: http://www.opensource.org/licenses/bsd-license.php
 */

_PSUtils = function(GLOBAL) {
    var createFolder, exceptionMessage, init, isMac, isWindows, log, that, throwFileError;
    that = this;
    this.enableLog = void 0;
    this.logFile = void 0;
    this.logFilePointer = void 0;
    isWindows = function() {
        return $.os.match(/windows/i);
    };
    isMac = function() {
        return !isWindows();
    };
    throwFileError = function(f, msg) {
        if (msg == null) {
            msg = '';
        }
        return Error.runtimeError(9002, "" + msg + "\"" + f + "\": " + f.error + ".");
    };
    exceptionMessage = function(e) {
        var msg = "Error " + e.number + ": " + e.message + ".\n" +
                  "Line: " + (e.line || '???') + "\n" +
                  "File: " + (e.fileName ? decodeURI(e.fileName) : '???');
        if ($.stack) {
            var stack = $.stack.split("\n");
            // remove last function call followed by an empty line
            stack.pop(); stack.pop();
            stack[stack.length - 1] = "-> " + stack[stack.length - 1];
            stack = stack.join("\n");
            msg += "\n" + stack;
        }
        return msg;
    };
    log = function(msg) {
        var file;
        if (!that.enableLog) {
            return;
        }
        file = that.logFilePointer;
        if (!file.open('e')) {
            throwFileError(file, "Unable to open Log file");
        }
        file.seek(0, 2);
        if (!file.writeln("" + msg)) {
            return throwFileError(file, "Unable to write to log file");
        }
    };
    createFolder = function(fptr) {
        var rc;
        if (fptr == null) {
            Error.runtimeError(19, "No Folder name specified");
        }
        if (fptr.constructor === String) {
            fptr = new Folder(decodeURI(fptr));
        }

        /* Recursion if the arg is a File */
        if (fptr instanceof File) {
            return createFolder(fptr.parent);
        }

        /* Are we done? */
        if (fptr.exists) {
            return true;
        }
        if (!(fptr instanceof Folder)) {
            log(fptr.constructor);
            Error.runtimeError(21, "Folder is not a Folder?");
        }
        if ((fptr.parent != null) && !fptr.parent.exists) {
            if (!createFolder(fptr.parent)) {
                return false;
            }
        }

        /* eventually...! */
        rc = fptr.create();
        if (!rc) {
            Error.runtimeError(9002, "Unable to create folder '" + fptr.fsName + "'' (" + fptr.error + ").");
        }
        return rc;
    };

    /*
     * Sets up the logging
     * @param  {string}  logFile      Log file name
     * @param  {Boolean} isLogEnabled To log or not to log...
     * @return {void}
     */
    init = function(logFile, isLogEnabled) {
        var file;
        if (!isLogEnabled) {
            return;
        }

        /* LOG Stuff */
        that.enableLog = isLogEnabled;
        that.logFile = logFile;

        /* Create Log File Pointer */
        file = new File(that.logFile);
        if (file.exists) {
            file.remove();
        }
        if (!file.open('w')) {
            throwFileError(file, "Unable to open Log file");
        }
        if (isMac()) {
            file.lineFeed = 'unix';
        }
        that.logFilePointer = file;
    };
    return {
        "isMac": isMac,
        "exceptionMessage": exceptionMessage,
        "log": log,
        "createFolder": createFolder,
        "init": init
    };
};

PSUtils = (_PSUtils)(this);

PSInstaller = (function() {

    /*
     * Set globals and start the logging
     * @return {void}
     */
    function PSInstaller() {

        /* set the log file name */
        G.LOG_FILE = "" + G.LOG_FILE_PATH + "/" + G.PRODUCT_NAME + ".log";

        /* init the logging */
        PSUtils.init(G.LOG_FILE, G.ENABLE_LOG);

        /* SCRIPTS, FLASH_PANEL, etc. */
        this.productsToInstall = [];

        /* All the folders to be copied (relative to the ASSETS path) */
        this.foldersList = [];

        /* List of Deployed Files and Folder - to be used by the uninstaller */
        this.installedFiles = [];
        this.installedFolders = [];
        PSUtils.log("=======================================\n " + (new Date()) + "\n \tCompany: " + G.COMPANY + "\n \tProduct: " + G.PRODUCT_NAME + "\n \tProduct version: " + G.PRODUCT_VERSION + "\n \tApp: " + BridgeTalk.appName + "\n \tApp Version: " + app.version + "\n \tOS: " + $.os + "\n \tLocale: " + $.locale + "\n ---------------------------------------\n \tInstaller Version: " + G.INSTALLER_VERSION + "\n =======================================");
        return;
    }


    /*
     * App compatibility check
     * @return {}
     */

    PSInstaller.prototype.preflight = function() {
        var _ref;
        G.MIN_VERSION = G.MIN_VERSION || 0;
        G.MAX_VERSION = G.MAX_VERSION || 99;
        PSUtils.log("\nPreflight \n----------------------------");
        if ((G.MIN_VERSION <= (_ref = G.CURRENT_PS_VERSION) && _ref <= G.MAX_VERSION)) {
            PSUtils.log("OK: PS version " + G.CURRENT_PS_VERSION + " in the range [" + G.MIN_VERSION + ", " + G.MAX_VERSION + "]");
            alert("" + G.COMPANY + " - " + G.PRODUCT_NAME + "\nPress OK to start the installation.\nThe process is going to be completed in a short while.");
            return true;
        } else {
            PSUtils.log("\nFAIL: PS version " + G.CURRENT_PS_VERSION + " not in the range [" + G.MIN_VERSION + ", " + G.MAX_VERSION + "]");
            return Error.runtimeError(9002, "Bad Photoshop version.\n" + G.CURRENT_PS_VERSION + " not in the range [" + G.MIN_VERSION + ", " + G.MAX_VERSION + "]");
        }
    };


    /*
     * Depending on the PS version, sets the available products options 
     * to install (@productsToInstall) and log them
     * @return {void}
     */

    PSInstaller.prototype.init = function() {
        var product, that, _i, _len, _ref;
        that = this;

        /* Array */
        this.productsToInstall = G.DEPENDENCIES[G.CURRENT_PS_VERSION] || G.DEPENDENCIES["*"];
        PSUtils.log("\nItems to be installed \n----------------------------");
        _ref = this.productsToInstall;
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
            product = _ref[_i];
            PSUtils.log("- " + product);
        }
    };

    PSInstaller.prototype.copy = function() {
        var allFiles, copyFiles, createRelativeFolder, destinationFolder, destinationPath, eachFolder, getFoldersList, ignoreRegExp, panelsPath, pluginsPath, product, saveFolder, scriptsPath, sourcePath, sourceFolder, that, _i, _j, _len, _len1, _ref, _ref1, _results, _success;
        that = this;

        /*
         * [createRelativeFolder description]
         * @param  {folder} destination     the destination Folder
         * @param  {folder} origin          the original, existing Folder
         * @param  {folder} base            the Folder used as a base
         * @return {folder} a new created folder in the destination
         */
        createRelativeFolder = function(destination, origin, base) {
            var destinationArray, destinationToWriteArray, destinationToWriteFolder, destinationToWriteString, originArray, originBaseArray;
            destinationArray = decodeURI(destination).toString().split('/');
            originArray = decodeURI(origin).toString().split('/');
            originBaseArray = decodeURI(base).toString().split('/');
            originArray.splice(0, originBaseArray.length);
            destinationToWriteArray = destinationArray.concat(originArray);
            destinationToWriteString = destinationToWriteArray.join('/');
            destinationToWriteFolder = Folder(destinationToWriteString);
            if (!destinationToWriteFolder.exists) {
                destinationToWriteFolder.create();
            }
            PSUtils.log("Created Folder:\t" + destinationToWriteFolder.fsName);
            that.installedFolders.push("" + destinationToWriteFolder.fsName);
            return destinationToWriteFolder;
        };

        /*
         * process the folder and fills the external
         * array of folders foldersList
         * @param  {folder} folder
         * @return {void}
         */
        getFoldersList = function(folder) {
            var i, item, list, _i, _len;
            if (folder.constructor === String) {
                folder = new Folder(folder);
            }
            list = folder.getFiles();
            i = 0;
            for (_i = 0, _len = list.length; _i < _len; _i++) {
                item = list[_i];
                if (item instanceof Folder) {
                    that.foldersList.push(item);
                    PSUtils.log("Folder: " + item.fsName);
                    getFoldersList(item);
                }
            }
        };

        /*
         * Copy Files to a Folder
         * @param  {array} files  Array of strings (File paths)
         * @param  {string} folder Folder path to copy to
         * @return {void}
         */
        copyFiles = function(files, folder) {
            var file, filesList, _i, _j, _len, _len1, _results, rc;
            filesList = [];
            for (_i = 0, _len = files.length; _i < _len; _i++) {
                file = files[_i];
                filesList.push(decodeURI(file));
            }
            _results = [];
            for (_j = 0, _len1 = filesList.length; _j < _len1; _j++) {
                file = filesList[_j];
                file = File(file);
                if (file.exists) {
                    rc = file.copy("" + folder + "/" + (file.name));

                    if (!rc) {
                        Error.runtimeError(9002, "Unable to copy file '" + file.fsName + "'' to '" + folder.fsName + "' (" + file.error + ").");
                    }
                    /* For the uninstaller */
                    that.installedFiles.push("" + folder + "/" + (file.name));
                    _results.push(PSUtils.log("Copied:\t\t" + (file.name)));
                } else {
                    _results.push(void 0);
                }
            }
            return _results;
        };

        /* Routine */
        _ref = this.productsToInstall;
        _results = [];
        _error = false;
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
            product = _ref[_i];
            if (!G[product]) {
                PSUtils.log("\n" + product + " - Nothing to install\n");
                continue;
            }
            switch (product) {
                case "SCRIPTS":
                    scriptsPath = "" + app.path + "/" + (localize('$$$/ScriptingSupport/InstalledScripts=Presets/Scripts'));
                    destinationPath = "" + scriptsPath + "/" + G.PRODUCT_NAME;
                    break;
                case "FLASH_PANEL":
                    panelsPath = "" + (G.SYSTEM_INSTALL ? Folder.commonFiles : Folder.userData) + "/Adobe/CS" + (G.CURRENT_PS_VERSION - 7) + "ServiceManager/extensions";
                    if (G.SYSTEM_INSTALL && $.os.match(/windows/i)) {
                        if (!Folder(decodeURI(panelsPath)).exists && !("" + Folder.commonFiles).match(/\(x86\)$/i)) {
                            panelsPath = "" + Folder.commonFiles + " (x86)/Adobe/CS" + (G.CURRENT_PS_VERSION - 7) + "ServiceManager/extensions";
                        }
                    }
                    destinationPath = "" + panelsPath + "/" + G.PRODUCT_ID;
                    break;
                case "HTML_PANEL":
                    panelsPath = "" + (G.SYSTEM_INSTALL ? Folder.commonFiles : Folder.userData) + "/Adobe/" + (G.CURRENT_PS_VERSION === '14' ? 'CEPServiceManager4' : 'CEP') + "/extensions";
                    if (G.SYSTEM_INSTALL && $.os.match(/windows/i)) {
                        if (!Folder(decodeURI(panelsPath)).exists && !("" + Folder.commonFiles).match(/\(x86\)$/i)) {
                            panelsPath = "" + Folder.commonFiles + " (x86)/Adobe/" + (G.CURRENT_PS_VERSION === '14' ? 'CEPServiceManager4' : 'CEP') + "/extensions";
                        }
                    }
                    destinationPath = "" + panelsPath + "/" + G.PRODUCT_ID;
                    break;
                case "MAC_PLUGIN":
                    if ($.os.match(/windows/i)) {
                        destinationPath = "";
                        break;
                    }
                    pluginsPath = "" + app.path + "/" + (localize('$$$/private/Plugins/DefaultPluginFolder=Plug-Ins'));
                    destinationPath = "" + pluginsPath + "/" + G.PRODUCT_ID;
                    break;
                case "WIN_PLUGIN":
                    if (!$.os.match(/windows/i)) {
                        destinationPath = "";
                        break;
                    }
                    pluginsPath = "" + app.path + "/" + (localize('$$$/private/Plugins/DefaultPluginFolder=Plug-Ins'));
                    destinationPath = "" + pluginsPath + "/" + G.PRODUCT_ID;
                    break;
                case "EXTRA":

                    /* TODO */
                    destinationPath = G.EXTRA;
            }
            if (destinationPath === "") {
                continue;
            }

            PSUtils.log("\n\nAdding " + product + "\n----------------------------\nDestination folder: " + (Folder(destinationPath).fsName));
            
            sourcePath = "" + G.CURRENT_PATH + "/" + G[product];

            /* Install a product */
            try {

                /* Create destination Folder */
                if (PSUtils.createFolder(destinationPath)) {
                    PSUtils.log("Destination Folder successfully created.\n");
                } else {
                    PSUtils.log("Error! Can't create destination folder.\n");
                }

                /* Create the Folder for the source from the string path */
                sourceFolder = Folder(sourcePath);

                /* Create the Folder for the destination from the string path */
                destinationFolder = Folder(destinationPath);
                

                /* Reset the array containing all the folders to be created in the destination */
                this.foldersList = [];

                /* Fill the foldersList */
                PSUtils.log("List of Folders to be copied for the " + product + ":\n");

                /* Log is in the getFolderl */
                getFoldersList(sourceFolder);

                /* Add the root folder to the list */
                this.foldersList.unshift(sourceFolder);
                PSUtils.log("Folder: " + sourceFolder);

                /* Create Folders tree in destination */
                PSUtils.log("\nCreating Folders in destination and copying files:\n");

                /* RegExp for ignoring files to be copied */
                ignoreRegExp = G.IGNORE ? new RegExp(G.IGNORE.join("|"), "i") : new RegExp("$.");
                _ref1 = this.foldersList;
                for (_j = 0, _len1 = _ref1.length; _j < _len1; _j++) {
                    eachFolder = _ref1[_j];
                    saveFolder = createRelativeFolder(destinationFolder, eachFolder, sourceFolder);
                    allFiles = eachFolder.getFiles(function(f) {
                        if (f instanceof Folder) {
                            return false;
                        } else {
                            if ((f.name.match(ignoreRegExp)) != null) {
                                return false;
                            }
                            return true;
                        }
                    });
                    if (allFiles.length) {
                        copyFiles(allFiles, saveFolder);
                    }
                }
                _results.push(PSUtils.log("\nEnded copying files for " + product + "."));

            } catch(e) {
                _error = true;
                PSUtils.log("\nUnable to install " + product + " from " + Folder(sourcePath).fsName + " to " + Folder(destinationPath).fsName + ":" + e.message);
                alert("Skipping installation step.\nUnable to install " + product.replace(/_/g, " ") + ".\nPlease try to run Photoshop as Administrator, or manually copy files from '" + Folder(sourcePath).fsName + "' to '" + Folder(destinationPath).fsName + "'.");
            }
        }
        if (_error) {
            Error.runtimeError(9002, "Unable to install one of products.");
        }
        return _results;
    };

    PSInstaller.prototype.wrapUp = function() {
        alert("Complete!\nAn installation LOG file has been created in:\n" + G.LOG_FILE);
        alert("Restart Photoshop\nYou must restart the application in orded to use " + G.PRODUCT_NAME + ", thank you!");
        if (G.README) {
            return (File("" + G.CURRENT_PATH + "/" + G.README)).execute();
        }
    };

    PSInstaller.prototype.createUninstaller = function() {
        var uninstall, uninstaller;
        uninstall = function(files, folders) {
            var e, eachFile, eachFolder, file, folder, performInstallation, uninstallErrors, _i, _j, _len;
            if (!(performInstallation = confirm("" + G.PRODUCT_NAME + " Version " + G.PRODUCT_VERSION + " Uninstaller\nAre you sure to remove " + G.PRODUCT_NAME + "?"))) {
                return;
            }
            uninstallErrors = false;
            G.LOG_FILE = "" + G.LOG_FILE_PATH + "/" + G.PRODUCT_NAME + " Uninstaller.log";

            /* init the logging */
            PSUtils.init(G.LOG_FILE, true);
            PSUtils.log("=======================================\n " + (new Date()) + "\n \tCompany: " + G.COMPANY + "\n \tProduct: " + G.PRODUCT_NAME + "\n \tProduct version: " + G.PRODUCT_VERSION + "\n \tApp: " + BridgeTalk.appName + "\n \tApp Version: " + app.version + "\n \tOS: " + $.os + "\n \tLocale: " + $.locale + "\n ---------------------------------------\n \tInstaller Version: " + G.INSTALLER_VERSION + "\n =======================================");
            PSUtils.log("\nRemoving FILES...");
            for (_i = 0, _len = files.length; _i < _len; _i++) {
                eachFile = files[_i];
                try {
                    file = File(eachFile);
                    PSUtils.log("Removing:\t" + file.fsName + "...");
                    file.remove();
                    PSUtils.log("Done!");
                } catch (e) {
                    PSUtils.log("ERROR!");
                    uninstallErrors = true;
                }
            }
            PSUtils.log("---------------------------------------\n Removing FOLDERS...");
            for (_j = folders.length - 1; _j >= 0; _j += -1) {
                eachFolder = folders[_j];
                try {
                    folder = Folder(eachFolder);
                    PSUtils.log("Removing:\t" + folder.fsName + "...");
                    folder.remove();
                    PSUtils.log("Done!");
                } catch (e) {
                    PSUtils.log("ERROR!");
                    uninstallErrors = true;
                }
                if (uninstallErrors) {
                    alert("Something went wrong!\nAn uninstallation LOG file has been created in:\n" + G.LOG_FILE + ", please send it to " + G.CONTACT_INFO);
                    throw Error("Restart Photoshop and see if the product has been uninstalled anyway.");
                }
            }
            return alert("" + G.PRODUCT_NAME + " successfully Removed\nPlease Restart Photoshop for the changes to take effect.");
        };
        uninstaller = new File("" + G.CURRENT_PATH + "/" + "uninstall.jsx");
        if (!uninstaller.open('w')) {
            throwFileError(uninstaller, "Unable to Write the Uninstaller file");
        }
        if (PSUtils.isMac()) {
            uninstaller.lineFeed = 'unix';
        }
        uninstaller.writeln("var G = " + (G.toSource()));
        uninstaller.writeln("var _PSUtils=" + _PSUtils.toString() + ";");
        uninstaller.writeln("var PSUtils=(_PSUtils)(this);");
        uninstaller.writeln("var filesToRemove = " + (this.installedFiles.toSource()) + ";");
        uninstaller.writeln("var foldersToRemove = " + (this.installedFolders.toSource()) + ";");
        uninstaller.writeln("var uninstall = " + (uninstall.toSource()) + ";");
        uninstaller.writeln("uninstall(filesToRemove, foldersToRemove);");
        return uninstaller.close();
    };

    return PSInstaller;

})();

try {
    psInstaller = new PSInstaller();
    psInstaller.preflight();
    psInstaller.init();
    psInstaller.copy();
    psInstaller.createUninstaller();
    psInstaller.wrapUp();
} catch (e) {
    PSUtils.log("Failed to complete installation: " + (PSUtils.exceptionMessage(e)));
    alert("Something went wrong!\n" + "Failed to complete installation: " + e.message + "\nPlease contact " + G.CONTACT_INFO + " if the problem persists. Thank you.");
}


/* EOF */

"psInstaller";
